% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c_GEVAQuantilesAdjusted.R
\docType{class}
\name{GEVAQuantilesAdjusted-class}
\alias{GEVAQuantilesAdjusted-class}
\alias{show,GEVAQuantilesAdjusted-method}
\alias{group.rels,GEVAQuantilesAdjusted-method}
\title{GEVA Adjusted Quantiles Results}

\value{
A \code{\linkS4class{GEVAQuantilesAdjusted}} object
}
\description{
The \code{GEVAQuantilesAdjusted} class represents the results of a quantile detection analysis with adjusted assignments based on relationships with other \code{GEVAGroupSet} objects. For each probe/gene, there is a assigned quantile among the \emph{g} defined quantiles.

This class inherits from \code{\linkS4class{GEVAQuantiles}}.
}
\section{Slots}{

\describe{
\item{\code{grouping}}{\code{factor} (\emph{m} elements, \emph{g} levels), quantile assignment for each gene/probe
\cr (Inherited from \code{\linkS4class{GEVAGroupSet}})}

\item{\code{scores}}{\code{numeric} vector (\emph{m} elements) with the assigned quantile scores for each gene/probe
\cr (Inherited from \code{\linkS4class{GEVAGroupSet}})}

\item{\code{ftable}}{\code{data.frame} (\emph{m} lines) with additional quantile assignment data
\cr (Inherited from \code{\linkS4class{GEVAGroupSet}})}

\item{\code{centroids}}{\code{numeric SVTable} (\emph{g} lines) with the S and V centroid coordinates for each quantile
\cr (Inherited from \code{\linkS4class{GEVAGroupSet}})}

\item{\code{offsets}}{\code{numeric SVTable} (\emph{m} lines) with the S and V coordinate offsets each gene/probe from its quantile centroid
\cr (Inherited from \code{\linkS4class{GEVAGroupSet}})}

\item{\code{info}}{\code{list} of additional information
\cr (Inherited from \code{\linkS4class{GEVAGroupSet}})}

\item{\code{svscores}}{\code{numeric \linkS4class{SVTable}} (\emph{m} lines) with individual partial scores for the assigned quantiles
\cr (Inherited from \code{\linkS4class{GEVAQuantiles}})}

\item{\code{qareasizes}}{\code{numeric \linkS4class{SVTable}} (\emph{g} lines) with the S and V sizes for each quantile
\cr (Inherited from \code{\linkS4class{GEVAQuantiles}})}

\item{\code{qindexes}}{\code{integer \linkS4class{SVTable}} (\emph{g} lines) representing the position index to each quantile, in terms of summary and variation
\cr (Inherited from \code{\linkS4class{GEVAQuantiles}})}

\item{\code{qcount}}{integer attributes (\code{\linkS4class{SVIntAttribute}}) with the defined number of quantiles for the S and V axes
\cr (Inherited from \code{\linkS4class{GEVAQuantiles}})}

\item{\code{qcutoff}}{numeric attributes (\code{\linkS4class{SVNumAttribute}}) with the initial quantile cutoff in S and V, starting from the point zero
\cr (Inherited from \code{\linkS4class{GEVAQuantiles}})}

\item{\code{grouprels}}{\code{\linkS4class{TypedList}} of \code{named factor} elements representing external group relationships to the current quantiles}
}}

\section{Methods}{
(See also the inherited methods from \code{\linkS4class{GEVAQuantiles}} and \code{\linkS4class{GEVAGroupSet}})\cr 


}

