% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threeJsGeometry.R
\docType{class}
\name{threeJsGeometry-class}
\alias{threeJsGeometry-class}
\alias{threeJsGeometry}
\alias{$,threeJsGeometry-method}
\alias{$<-,threeJsGeometry-method}
\alias{show,threeJsGeometry-method}
\title{Class \code{"threeJsGeometry"}}
\usage{
threeJsGeometry(...)

\S4method{$}{threeJsGeometry}(x, name)

\S4method{$}{threeJsGeometry}(x, name) <- value

\S4method{show}{threeJsGeometry}(object)
}
\arguments{
\item{\dots}{Each argument in \dots becomes an slot in the new threeJsGeometry.}

\item{x}{an object of threeJsGeometry}

\item{name}{slot name of threeJsGeometry}

\item{value}{value to be assigned}

\item{object}{an object of threeJsGeometry}
}
\description{
An object of class \code{"threeJsGeometry"}
             represents `three.js` geometry.
}
\section{Slots}{

\describe{
\item{\code{x,y,z}}{\code{"numeric"}, specify the x, y, and z coordinates.}

\item{\code{rotation}}{\code{"numeric"}, specify the rotations in the x, y and 
z axis in radians.}

\item{\code{colors}}{\code{"character"}, the colors for each geometry.}

\item{\code{type}}{\code{"charater"}, the type of the geometry.
See \link{availableGeometries}.}

\item{\code{side}}{\code{'character'}, the side for side by side plot in
\link{threeJsViewer}.}

\item{\code{layer}}{\code{'character'}, the two layer plot in
\link{threeJsViewer}.}

\item{\code{tag}}{\code{'character'}, the tag used to group geometries.}

\item{\code{properties}}{A \code{"list"}, the properties to control the geometry.}
}}

\examples{
tjg <- threeJsGeometry()

}
