% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readAnnotate.R
\docType{methods}
\name{plotTargetAnnotation}
\alias{plotTargetAnnotation}
\alias{plotTargetAnnotation,AnnotationByFeature-method}
\title{Plot annotation categories from AnnotationByGeneParts or AnnotationByFeature}
\usage{
plotTargetAnnotation(x, precedence = TRUE,
  col = getColors(length(x@annotation)), cex.legend = 1, ...)

\S4method{plotTargetAnnotation}{AnnotationByFeature}(x, precedence = TRUE,
  col = getColors(length(x@annotation)), cex.legend = 1, ...)
}
\arguments{
\item{x}{a \code{AnnotationByFeature} or
\code{AnnotationByGeneParts} object}

\item{precedence}{TRUE|FALSE. If TRUE there will be a hierachy of annotation 
features when calculating numbers 
(with promoter>exon>intron precedence). 
This option is only valid when x is a 
\code{AnnotationByGeneParts} object}

\item{col}{a vector of colors for piechart or the bar plot}

\item{cex.legend}{a numeric value of length 1 to specify the size of the legend. By default 1.}

\item{...}{graphical parameters to be passed to \code{pie} 
or \code{barplot} functions}
}
\value{
plots a piechart or a barplot for percentage of 
        the target features overlapping with annotation
}
\description{
This function plots a pie or bar chart for showing percentages of targets 
annotated by genic parts or other query features
}
\examples{
data(cage)

bed.file = system.file("extdata/chr21.refseq.hg19.bed", package = "genomation")
gene.parts = readTranscriptFeatures(bed.file)
annot = annotateWithGeneParts(cage, gene.parts, intersect.chr=TRUE)
\donttest{
plotTargetAnnotation(annot)
}

}
