% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichmentMatrix.R
\docType{methods}
\name{enrichmentMatrix}
\alias{enrichmentMatrix}
\alias{enrichmentMatrix,ScoreMatrix,ScoreMatrix-method}
\title{Compute an enrichment of IP over control both stored in ScoreMatrix objects}
\usage{
\\S4method{enrichmentMatrix}{ScoreMatrix,ScoreMatrix}(IP, control)
}
\arguments{
\item{IP}{\code{\link{ScoreMatrix}} object storing an IP sample}

\item{control}{\code{\link{ScoreMatrix}} object storing a control sample}
}
\value{
\code{ScoreMatrix} object
}
\description{
This is an \code{enrichmentMatrix} function for \code{ScoreMatrix} objects, 
that enables to normalize ChIP-seq signals with respect to IgG or input DNA control.
}
\note{
The function computes an enrichment of IP over control as follow:
Suppose both IP and control are ScoreMatrix objects that have same dimensions. 
Then, the enrichment is calculated usign a formula: log2((IP + 1) / (control + 1)).
}
\examples{
 
#load IP and control BAM files and create ScoreMatrix objects
library('genomationData')
bam.file_IP <- system.file("extdata", 
"wgEncodeBroadHistoneH1hescSuz12051317AlnRep1.chr21.bam", package = "genomationData")
bam.file_c <- system.file("extdata", 
"wgEncodeBroadHistoneH1hescCtcfStdAlnRep1.chr21.bam", package = "genomationData")
data(promoters)
IP <- ScoreMatrix(target = bam.file_IP, windows = promoters, type = 'bam')
control <- ScoreMatrix(target = bam.file_c, windows = promoters, type = 'bam')

# compute an enrichment of IP over control
enrichmentMatrix(IP, control)

}
\seealso{
\code{\link{ScoreMatrix}}
}
