% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted.meanvar.R
\name{weighted.meanvar}
\alias{weighted.meanvar}
\title{Function to compute the weighted mean and weighted variance of 'x'}
\usage{
weighted.meanvar(x, w, na.rm = FALSE)
}
\arguments{
\item{x}{an object containing the values whose weighted mean is to be computed.}

\item{w}{a numerical vector of weights of the same length as x giving the
weights to use for elements of x.}

\item{na.rm}{TRUE if missing values should be removed, FALSE otherwise.}
}
\value{
A numeric vector of two values that are the weighted mean and weighted
variance respectively.
}
\description{
This function allows for computing the weighted mean and weighted variance
of a vector of continuous values.
}
\details{
If w is missing then all elements of x are given the same weight, otherwise
the weights coerced to numeric by as.numeric. On the contrary of
weighted.mean the weights are NOT normalized to sum to one. If the sum
of the weights is zero or infinite, NAs will be returned.
}
\examples{
set.seed(54321)
weighted.meanvar(x=rnorm(100) + 10, w=runif(100))

}
\references{
http://en.wikipedia.org/wiki/Weighted_variance#Weighted_sample_variance
}
\seealso{
\link[stats:weighted.mean]{stats::weighted.mean}
}
