% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene70.R
\name{gene70}
\alias{gene70}
\title{Function to compute the 70 genes prognosis profile (GENE70) as published by
van't Veer et al. 2002}
\usage{
gene70(data, annot, do.mapping = FALSE, mapping,
  std = c("none", "scale", "robust"), verbose = FALSE)
}
\arguments{
\item{data}{Matrix of gene expressions with samples in rows and probes in columns,
dimnames being properly defined.}

\item{annot}{Matrix of annotations with at least one column named "EntrezGene.ID",
dimnames being properly defined.}

\item{do.mapping}{TRUE if the mapping through Entrez Gene ids must be performed (in case
of ambiguities, the most variant probe is kept for each gene), FALSE otherwise.}

\item{mapping}{Matrix with columns "EntrezGene.ID" and "probe" used to force the mapping
such that the probes are not selected based on their variance.}

\item{std}{Standardization of gene expressions: scale for traditional standardization based
on mean and standard deviation, robust for standardization based on the 0.025 and
0.975 quantiles, none to keep gene expressions unchanged.}

\item{verbose}{TRUE to print informative messages, FALSE otherwise.}
}
\value{
A list with items:
\itemize{
\item score Continuous signature scores
\item risk Binary risk classification, 1 being high risk and 0 being low risk.
\item mapping Mapping used if necessary.
\item probe If mapping is performed, this matrix contains the correspondence between
the gene list (aka signature) and gene expression data
}
}
\description{
This function computes signature scores and risk classifications from gene expression
values following the algorithm used for the 70 genes prognosis profile (GENE70) as
published by van't Veer et al. 2002.
}
\examples{
# load GENE70 signature
data(sig.gene70)
# load NKI dataset
data(nkis)
# compute relapse score
rs.nkis <- gene70(data=data.nkis)
table(rs.nkis$risk)
# note that the discrepancies compared to the original publication
# are closed to the official cutoff, raising doubts on its exact value.
# computation of the signature scores on a different microarray platform
# load VDX dataset
data(vdxs)
# compute relapse score
rs.vdxs <- gene70(data=data.vdxs, annot=annot.vdxs, do.mapping=TRUE)
table(rs.vdxs$risk)

}
\references{
L. J. van't Veer and H. Dai and M. J. van de Vijver and Y. D. He and A. A. Hart and
M. Mao and H. L. Peterse and K. van der Kooy and M. J. Marton and A. T. Witteveen and
G. J. Schreiber and R. M. Kerkhiven and C. Roberts and P. S. Linsley and R. Bernards
and S. H. Friend (2002) "Gene Expression Profiling Predicts Clinical Outcome of Breast
Cancer", Nature, 415:530–536.
}
\seealso{
nkis
}
