% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endoPredict.R
\name{endoPredict}
\alias{endoPredict}
\title{Function to compute the endoPredict signature as published by Filipits et al 2011}
\usage{
endoPredict(data, annot, do.mapping = FALSE, mapping, verbose = FALSE)
}
\arguments{
\item{data}{Matrix of gene expressions with samples in rows and probes in columns,
dimnames being properly defined.}

\item{annot}{Matrix of annotations with at least one column named "EntrezGene.ID",
dimnames being properly defined.}

\item{do.mapping}{TRUE if the mapping through Entrez Gene ids must be performed (in
case ofambiguities, the most variant probe is kept for each gene), FALSE otherwise.
Note that for Affymetrix HGU datasets, the mapping is not necessary.}

\item{mapping}{Matrix with columns "EntrezGene.ID" and "probe" used to force the mapping
such that the probes are not selected based on their variance.}

\item{verbose}{TRUE to print informative messages, FALSE otherwise.}
}
\value{
A list with items:
-score Continuous signature scores
-risk Binary risk classification, 1 being high risk and 0 being low risk.
-mapping Mapping used if necessary.
-probe If mapping is performed, this matrix contains the correspondence between the gene
list (aka signature) and gene expression data.
}
\description{
This function computes signature scores and risk classifications from gene expression
values following the algorithm used for the endoPredict signature as published by
Filipits et al 2011.
}
\details{
The function works best if data have been noralized with MAS5. Note that for Affymetrix
HGU datasets, the mapping is not necessary.
}
\examples{
# load GENE70 signature
data(sig.endoPredict)
# load NKI dataset
data(vdxs)
# compute relapse score
rs.vdxs <- endoPredict(data=data.vdxs, annot=annot.vdxs, do.mapping=FALSE)

}
\references{
Filipits, M., Rudas, M., Jakesz, R., Dubsky, P., Fitzal, F., Singer, C. F., et al. (2011).
"A new molecular predictor of distant recurrence in ER-positive, HER2-negative
breast cancer adds independent information to conventional clinical risk factors."
Clinical Cancer Research, 17(18):6012–6020.
}
