% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linePlot.r
\name{linePlot}
\alias{linePlot}
\title{Produces line plots.}
\usage{
linePlot(organism, start, end, by)
}
\arguments{
\item{organism}{Object name assigned from readGFF() command.}

\item{start}{Lower bound of upstream extension.}

\item{end}{Upper bound of upstream extension.}

\item{by}{Interval between consecutive extensions.}
}
\value{
Creates differential line plots.
}
\description{
Makes differential line plots showing the differences in the number of genes under peaks at consecutive upstream extension levels.
}
\examples{
library(rtracklayer)
rat <- readGFF("ftp://ftp.ensembl.org/pub/release-84/gtf/rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.84.gtf.gz")
fpath <- system.file("extdata", "somepeaksfile.txt", package="geneXtendeR")
peaksInput(fpath)
linePlot(rat, 1000, 3000, 100)


}
