% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate_n.r
\name{annotate_n}
\alias{annotate_n}
\title{Annotate peaks file.}
\usage{
annotate_n(organism, extension, n = 2)
}
\arguments{
\item{organism}{Object name assigned from readGFF() command.}

\item{extension}{Desired upstream extension.}

\item{n}{Number of Gene's closest away from the peak}
}
\value{
The gene coordinates are extended by `extension` at the 5-prime end, and by 500 bp at the 3-prime end.  The peaks file is then overlayed on these new gene coordinates, producing a file of peaks annotated with gene ID, gene name, and gene-to-peak genomic distance (in bp).  Distance is calculated between 5-prime end of gene and 3-prime end of peak. File named "annotated_'extension'_'n'.txt".

A data.table formatted version of the annotated file for checking or further calculations.
}
\description{
Annotate a user's peaks file (which has been preprocessed with the peaksInput() command) with gene information based on optimally chosen geneXtendeR upstream extension file.  This command requires a preprocessed "peaks.txt" file (generated using peaksInput()) to be present in the user's working directory, otherwise the user is prompted to rerun the peaksInput() command in order to regenerate it.
}
\examples{
\dontrun{
rat <- readGFF("ftp://ftp.ensembl.org/pub/release-84/gtf/rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.84.gtf.gz")
fpath <- system.file("extdata", "somepeaksfile.txt", package="geneXtendeR")
peaksInput(fpath)
annotate_n(rat, 2500, n=3)
}

}
