% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R,
%   R/Class_ClassifierResults.R
\docType{methods}
\name{getScores}
\alias{getScores}
\alias{getScores,ClassifierResults-method}
\title{Obtain classifier score.}
\usage{
getScores(object)

\S4method{getScores}{ClassifierResults}(object)
}
\arguments{
\item{object}{An object of class \code{\link{ClassifierResults}}}
}
\value{
A numeric vector with scores per sample
}
\description{
\code{getScores} returns the resulting scores from a classifier
run
}
\examples{
data(exampleMAS5)
myData <- setNormalizationMethod(exampleMAS5, "MAS5.0", targetValue=500)
results <- runClassifier('EMC92', myData)
getScores( results )
getClassifications( results )
}
\seealso{
Other classifier results: \code{\link{getBatchCorrection}},
  \code{\link{getClassifications}},
  \code{\link{getWeightingType}}
}
\concept{classifier results}
