% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R,
%   R/Class_ClassifierParameters.R
\docType{methods}
\name{getProbeNames}
\alias{getProbeNames}
\alias{getProbeNames,ClassifierParameters-method}
\title{Obtain probe-set names.}
\usage{
getProbeNames(object)

\S4method{getProbeNames}{ClassifierParameters}(object)
}
\arguments{
\item{object}{An object of class \code{\link{ClassifierParameters}}
as returned by \code{\link{getClassifier}}}
}
\value{
The return value is a character vector of probe-set names.
}
\description{
\code{getProbeNames} returns the probe names associated with
the requested classifier.
}
\examples{
aClassifier <- getClassifier("EMC92")
getProbeNames( aClassifier )
}
\seealso{
\code{\link{ClassifierParameters}}

Other classifier information functions: \code{\link{getCitations}},
  \code{\link{getClassifier}},
  \code{\link{getDecisionBoundaries}},
  \code{\link{getDescription}},
  \code{\link{getEventChain}}, \code{\link{getIntercept}},
  \code{\link{getMeans}},
  \code{\link{getNormalizationMethod}},
  \code{\link{getSds}}, \code{\link{getTrainingData}},
  \code{\link{getWeights}}
}
\concept{classifier information functions}
