% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R,
%   R/Class_ClassifierParameters.R
\docType{methods}
\name{getCitations}
\alias{getCitations}
\alias{getCitations,ClassifierParameters-method}
\title{Obtain citations to the classifier}
\usage{
getCitations(object)

\S4method{getCitations}{ClassifierParameters}(object)
}
\arguments{
\item{object}{An object of class \code{\link{ClassifierParameters}}
as returned by \code{\link{getClassifier}}}
}
\value{
A character vector
}
\description{
\code{getCitations} Obtain citations to the classifier
}
\examples{
aClassifier <- getClassifier("EMC92")
getCitations(aClassifier)
}
\seealso{
Other classifier information functions: \code{\link{getClassifier}},
  \code{\link{getDecisionBoundaries}},
  \code{\link{getDescription}},
  \code{\link{getEventChain}}, \code{\link{getIntercept}},
  \code{\link{getMeans}},
  \code{\link{getNormalizationMethod}},
  \code{\link{getProbeNames}}, \code{\link{getSds}},
  \code{\link{getTrainingData}}, \code{\link{getWeights}}
}
\concept{classifier information functions}
