% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneAttribution.R
\name{geneModels}
\alias{geneModels}
\title{Load gene models}
\usage{

  geneModels(txdb = TxDb.Hsapiens.UCSC.hg38.knownGene::TxDb.Hsapiens.UCSC.hg38.knownGene,
  maxGeneLength = 1e+06, genesToInclude, genesToExclude)
}
\arguments{
\item{txdb}{GenomicFeatures TxDb object containing genomic coordinates of genes}

\item{maxGeneLength}{An integer. Gene models that are longer than this are excluded. Optional}

\item{genesToInclude}{A character vector of gene symbols of genes to include (e.g. only protein coding genes). Optional}

\item{genesToExclude}{A character vector of gene symbols of genes to exclude. Optional}
}
\value{
A GenomicRanges object containing human gene models
}
\description{
Get gene models as a GenomicRanges object, with gene names in the symbol column
For hg19, you may want to use TxDb.Hsapiens.UCSC.hg19.knownGene and for GRCh38,
TxDb.Hsapiens.UCSC.hg38.knownGene (set as default)
}
\examples{
geneModels()
geneModels(genesToInclude = c("CYYR1", "ADAMTS1", "ADAMTS5", "N6AMT1", "LTN1"))
}

