% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allEndpoints.R
\name{get_platform_element_genes}
\alias{get_platform_element_genes}
\title{Retrieve the genes associated to a probe in a given platform}
\usage{
get_platform_element_genes(
  platform,
  probe,
  offset = 0L,
  limit = 20L,
  raw = getOption("gemma.raw", FALSE),
  memoised = getOption("gemma.memoised", FALSE),
  file = getOption("gemma.file", NA_character_),
  overwrite = getOption("gemma.overwrite", FALSE)
)
}
\arguments{
\item{platform}{A platform numerical identifier or a platform short name}

\item{probe}{A probe name or it's numerical identifier}

\item{offset}{The offset of the first retrieved result.}

\item{limit}{Defaults to 20. Limits the result to specified amount
of objects. Has a maximum value of 100. Use together with \code{offset} and
the \code{totalElements} \link[base:attributes]{attribute} in the output to
compile all data if needed.}

\item{raw}{\code{TRUE} to receive results as-is from Gemma, or \code{FALSE} to enable
parsing. Raw results usually contain additional fields and flags that are
omitted in the parsed results.}

\item{memoised}{Whether or not to save to cache for future calls with the
same inputs and use the result saved in cache if a result is already saved.
Doing \code{options(gemma.memoised = TRUE)} will ensure that the cache is always
used. Use \code{\link{forget_gemma_memoised}} to clear the cache.}

\item{file}{The name of a file to save the results to, or \code{NULL} to not write
results to a file. If \code{raw == TRUE}, the output will be the raw endpoint from the
API, likely a JSON or a gzip file. Otherwise, it will be a RDS file.}

\item{overwrite}{Whether or not to overwrite if a file exists at the specified
filename.}
}
\value{
A data table with information about the querried gene(s)
A list if \code{raw = TRUE}.

The fields of the output data.table are:

\itemize{
\item \code{gene.symbol}: Symbol for the gene
\item \code{gene.ensembl}: Ensembl ID for the gene
\item \code{gene.NCBI}: NCBI id for the gene
\item \code{gene.name}: Name of the gene
\item \code{gene.aliases}: Gene aliases. Each row includes a vector
\item \code{gene.MFX.rank}: Multifunctionality rank for the gene
\item \code{taxon.name}: Name of the species
\item \code{taxon.scientific}: Scientific name for the taxon
\item \code{taxon.ID}: Internal identifier given to the species by Gemma
\item \code{taxon.NCBI}: NCBI ID of the taxon
\item \code{taxon.database.name}: Underlying database used in Gemma for the taxon
\item \code{taxon.database.ID}: ID of the underlying database used in Gemma for the taxon
}
}
\description{
Retrieve the genes associated to a probe in a given platform
}
\examples{
get_platform_element_genes("GPL1355", "AFFX_Rat_beta-actin_M_at")
}
\keyword{platform}
