% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{has_valid_codrug_data}
\alias{has_valid_codrug_data}
\title{Has Valid Codrug Data}
\usage{
has_valid_codrug_data(
  data,
  prettify_identifiers = TRUE,
  codrug_name_identifier = "drug_name2",
  codrug_conc_identifier = "concentration2"
)
}
\arguments{
\item{data}{data.table with input data}

\item{prettify_identifiers}{logical flag specifying if identifiers are expected to be prettified}

\item{codrug_name_identifier}{string with the identifiers for the codrug drug_name column}

\item{codrug_conc_identifier}{string with the identifiers for the codrug concentration column}
}
\value{
logical flag
}
\description{
Has Valid Codrug Data
}
\examples{
dt <-
  data.table::data.table(
    "Drug Name" = letters[seq_len(3)],
    "Concentration" = seq_len(3),
    "Drug Name 2" = letters[4:6],
    "Concentration 2" = 4:6
  )
has_valid_codrug_data(dt)

dt$`Concentration 2` <- NULL
has_valid_codrug_data(dt)

}
\keyword{combination_data}
