% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D300.R
\name{import_D300}
\alias{import_D300}
\title{Import D300}
\usage{
import_D300(D300_file, metadata_file, destination_path)
}
\arguments{
\item{D300_file}{character, file path to D300 file}

\item{metadata_file}{character, file path to file with mapping from D300 names to Gnumbers}

\item{destination_path}{character, path to folder where template
files will be generated}
}
\value{
Create one Excel file per plate. Each sheet in each plate file describes
the drugs and corrresponding concentrations of what was tested in each well.
}
\description{
This functions takes a D300 file and generates corresponding template files
}
\details{
For example, wells treated with 2 drugs in combination will result in 4 sheets per plate.
\itemize{
\item{Sheet 1: Drug 1}
\item{Sheet 2: Conc of Drug 1}
\item{Sheet 3: Drug 2}
\item{Sheet 4: Conc of Drug 2}
}
}
\examples{
td3 <- get_test_D300_data()[["f_96w"]]
o_path <- file.path(tempdir(), "td3")
dir.create(o_path)
import_D300(td3$d300, td3$Gnum, o_path)
list.files(o_path)
unlink(o_path, recursive = TRUE)

}
\keyword{D300}
