% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAE_to_PSet.R
\name{convert_MAE_to_PSet}
\alias{convert_MAE_to_PSet}
\title{Convert MultiAssayExperiment to TreatmentResponseExperiment}
\usage{
convert_MAE_to_PSet(mae, pset_name)
}
\arguments{
\item{mae}{A MultiAssayExperiment object generated by gDR.}

\item{pset_name}{A character string specifying the name of the resulting PharmacoSet object.}
}
\value{
A PharmacoSet object.
}
\description{
This function converts a MultiAssayExperiment generated by gDR into a TreatmentResponseExperiment for use in the
PharmacoGx package. The resulting PharmacoSet can be used for pharmacogenomic analysis of drug response.
}
\examples{
# Convert a MultiAssayExperiment object to a PharmacoSet object
m <- 20
n <- 10
rnames <- LETTERS[1:m]
cnames <- letters[1:n]
ref_gr_value <-  matrix(runif(m * n), nrow = m, ncol = n, dimnames = list(rnames, cnames))
se <- SummarizedExperiment::SummarizedExperiment(assays = list(RefGRvalue = ref_gr_value),
                                                 rowData = S4Vectors::DataFrame(rnames),
                                                 colData = S4Vectors::DataFrame(cnames))
mae <- MultiAssayExperiment::MultiAssayExperiment(experiments = list("single-agent" = se))
convert_MAE_to_PSet(mae, "my_pset")

}
\keyword{pset_conversion}
