% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.utils.R
\name{test_synthetic_data}
\alias{test_synthetic_data}
\title{Testing synthetic data form gDRtestData package}
\usage{
test_synthetic_data(
  original,
  data,
  dataName,
  override_untrt_controls = NULL,
  assays = c("Normalized", "Averaged", "Metrics"),
  tolerance = 0.001
)
}
\arguments{
\item{original}{original MAE assay}

\item{data}{datase MAE or data.table}

\item{dataName}{dataset name}

\item{override_untrt_controls}{named list containing defining factors in
the treatments}

\item{assays}{assays to test}

\item{tolerance}{tolerance factor}
}
\value{
\code{NULL}
}
\description{
Testing synthetic data form gDRtestData package
}
\examples{
set.seed(2)
cell_lines <- gDRtestData::create_synthetic_cell_lines()
drugs <- gDRtestData::create_synthetic_drugs()
data <- "finalMAE_small"
original <- gDRutils::get_synthetic_data(data)
test_synthetic_data(original, original, "test")

}
\keyword{test_utils}
