% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_keys.R
\name{identify_keys}
\alias{identify_keys}
\title{identify_keys}
\usage{
identify_keys(
  df_,
  nested_keys = NULL,
  override_untrt_controls = NULL,
  identifiers = gDRutils::get_env_identifiers()
)
}
\arguments{
\item{df_}{a data.table to identify keys for.}

\item{nested_keys}{character vector of keys to exclude from the returned
list. The keys discarded should be identical to the keys in the third
dimension of the SummarizedExperiment.
Defaults to the \code{"Barcode"} and the \code{masked} identifier.}

\item{override_untrt_controls}{named list containing defining factors in the
treatments. Defaults to \code{NULL}.}

\item{identifiers}{named list containing all identifiers to use during
processing. By default, this value will be obtained by the environment.}
}
\value{
named list of key types and their corresponding key values.
}
\description{
Group columns from a data.table that correspond to different
}
\details{
This is most likely to be used for provenance tracking and will
be placed on the SummarizedExperiment metadata for downstream analyses
to reference.
}
\examples{
n <- 64
md_df <- data.table::data.table(
  Gnumber = rep(c("vehicle", "untreated", paste0("G", seq(2))), each = 16), 
  DrugName = rep(c("vehicle", "untreated", paste0("GN", seq(2))), each = 16), 
  clid = paste0("C", rep_len(seq(4), n)),
  CellLineName = paste0("N", rep_len(seq(4), n)),
  replicates = rep_len(paste0("R", rep(seq(4), each = 4)), 64),
  drug_moa = "inhibitor",
  ReferenceDivisionTime = rep_len(c(120, 60), n),
  Tissue = "Lung",
  parental_identifier = "CL12345",
  Duration = 160
)
md_df <- unique(md_df)
ref <- md_df$Gnumber \%in\% c("vehicle", "untreated")
trt_df <- md_df[!ref, ]
identify_keys(trt_df)

}
\seealso{
map_df, create_SE
}
\keyword{utils}
