% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combinations-helpers.R
\name{calculate_score}
\alias{calculate_score}
\title{Calculate score for HSA and Bliss}
\usage{
calculate_score(excess)
}
\arguments{
\item{excess}{numeric vector with excess}
}
\value{
numeric vector with calculated score
}
\description{
Calculate score for HSA and Bliss
}
\examples{
metric <- data.table::data.table(
  Concentration = c(1, 2, 3, 1, 2, 3),
  Concentration_2 = c(1, 1, 1, 2, 2, 2),
  GRvalue = c(100, 200, 300, 400, 500, 600)
)
measured <- data.table::data.table(
  Concentration = c(3, 1, 2, 2, 1, 3),
  Concentration_2 = c(1, 1, 1, 2, 2, 2),
  testvalue = c(200, 0, 100, 400, 300, 500)
)
series_identifiers <- c("Concentration", "Concentration_2")
metric_col <- "GRvalue"
measured_col <- "testvalue"
x <- calculate_excess(
  metric, 
  measured, 
  series_identifiers, 
  metric_col, 
  measured_col
)
calculate_score(x$x)

}
\keyword{combinations}
