% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RRAalpha.R
\name{ct.RRAalphaBatch}
\alias{ct.RRAalphaBatch}
\title{Create Batches of Null Permutations for a Crispr Screen}
\usage{
ct.RRAalphaBatch(
  p,
  g.key,
  result.environment,
  batch.size = 100,
  permutation.seed = NULL
)
}
\arguments{
\item{p}{A single column matrix of rank statistics, with row.names indicating the gRNA labels.}

\item{g.key}{data.frame with guide and gene names}

\item{result.environment}{The target environment containing the quasi-global variables incremented during the permutations in the child functions.}

\item{batch.size}{Number of iterations to deploy to each daughter process.}

\item{permutation.seed}{numeric seed for permutation reproducibility. Default is \code{NULL}, in which case no seed is set.}
}
\value{
An integer vector indicating the number of iterations in which each gene's score was better than those indicated in \code{result.environment$obs}.
}
\description{
This is a wrapper function to partition batches of calls to \code{ct.RRAalpha()} for multicore processing. 
It is called internally as a single instance of the beta aggregation step in RRAa. Users should not interact with it directly.
}
\author{
Russell Bainer
}
\keyword{internal}
