% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FlowHist.R
\name{findPeaks}
\alias{findPeaks}
\alias{cleanPeaks}
\title{findPeaks}
\usage{
findPeaks(fh, window = 20, smooth = 20)

cleanPeaks(fh, window = 20, debrisLimit = 40)
}
\arguments{
\item{fh}{a \code{\link{FlowHist}} object}

\item{window}{an integer, the width of the moving window to use in
identifying local maxima via \code{\link{runmax}}}

\item{smooth}{an integer, the width of the moving window to use in
removing noise via \code{\link{runmean}}}

\item{debrisLimit}{an integer value. Peaks with fluorescence values less than
\code{debrisLimit} will be ignored by the automatic peak-finding algorithm.}
}
\value{
Returns a matrix with two columns:
\describe{
\item{mean}{the index position of each potential peak}
\item{height}{the height (intensity) of the peak at that index position}
}
}
\description{
Locate potential peaks in histogram data
}
\details{
Peaks are defined as local maxima in the vector of values, using a
moving window. Note that these are used in the context of finding
starting values - accuracy isn't important, we just need something
`close-enough' that the nls algorithm will be able to find the correct
value.

Utility functions for use internally by flowPloidy; not exported and
won't be visible to users. Usually invoked from within
\code{\link{FlowHist}}. 

Note that there is a trade-off between accuracy in detected peaks, and
avoiding noise. Increasing the value of \code{smooth} will reduce the
amount of 'noise' that is included in the peak list. However, increasing
smoothing shifts the location of the actual peaks. Most of the time the
default values provide an acceptable compromise, given we only need to
get 'close enough' for the NLS optimization to find the true parameter
values. If you'd like to explore this, the internal (unexported)
function \code{fhPeakPlot} may be useful.

\code{\link{cleanPeaks}} filters the output of
  \code{\link{findPeaks}} to:   
\itemize{

\item remove duplicates, ie., peaks with the same intensity that occur
within \code{window} positions of each other. Otherwise,
\code{\link{findPeaks}} will consider noisy peaks without a single
highest point to be multiple distinct peaks.

\item drop G2 peaks. In some cases the G2 peak for one sample will have
greater intensity than the G1 peak for another sample. We correct for
this by removing detected peaks with means close to twice that of other
peaks. This step is skipped for endopolyploidy analysis (i.e., when G2
== FALSE). 

\item ignore noise, by removing peaks with \code{fluorescence} <
\code{debrisLimit}. The default is 40, which works well for
moderate-to-large debris fields. You may need to reduce this value if
you have clean histograms with peaks below 40. Note that this value does
not affect peaks selected manually. }
}
\examples{
\dontrun{
set.seed(123)
test.dat <-(cumsum(runif(1000, min = -1)))
plot(test.dat, type = 'l')
test.peaks <- flowPloidy::findPeaks(test.dat, window = 20)
points(test.peaks, col = 'red', cex = 2)
}

}
\author{
Tyler Smith
}
\keyword{internal}
