% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_graph.R
\name{get_phen_list}
\alias{get_phen_list}
\title{Creates edge lists.}
\usage{
get_phen_list(meta_cell = NULL, phen = NULL, no_cores = 1)
}
\arguments{
\item{meta_cell}{A data frame containing meta data on cell populations
as produced by the \code{get_phen_meta} function.}

\item{phen}{A string vector of phenotype or cell population name labels.
Cannot be set to \code{NULL} if \code{meta_cell} is set to \code{NULL}.}

\item{no_cores}{An integer indicating how many cores to parallelize on.}
}
\value{
A list containing 'pchild', an edge list
   indicating where edges point to,
   'pparen', an edge list indicating where edges point from, and
   'edf', a data frame where each row contains
   the nodes an edge points 'from' and 'to'.
}
\description{
Creates edge lists indicating relationships
between cell populations
   given meta data on these cell populations
   produced by the \code{get_phen_meta} function.
}
\examples{

   phen <- c('A+B-C+', 'A+B-', 'A+')
   get_phen_list(phen=phen)

}
\seealso{
\code{\link[flowGraph]{get_phen_meta}}
   \code{\link[flowGraph]{cell_type_layers}}
}
