% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_flowgraph_constructor.R
\name{flowGraph}
\alias{flowGraph}
\title{flowGraph object constructor.}
\usage{
flowGraph(
  input_,
  meta = NULL,
  class = "class",
  no_cores = 1,
  markers = NULL,
  layout_fun = "layout.reingold.tilford",
  max_layer = NULL,
  cumsumpos = FALSE,
  prop = TRUE,
  specenr = TRUE,
  path = NULL,
  calculate_summary = TRUE,
  node_features = "SpecEnr",
  edge_features = "NONE",
  test_name = "t_diminish",
  test_custom = "t",
  diminish = TRUE,
  label1 = NULL,
  label2 = NULL,
  save_plots = FALSE
)
}
\arguments{
\item{input_}{Any of the following:
\itemize{
  \item{a numeric matrix or vector of the cell counts;
  its column/names must be the phenotype names and its rownames
  must be sample ID's.}
}
All input samples should have the same \code{markers} and
\code{partitionsPerMarker}.}

\item{meta}{A data frame with meta data for each \code{Phenotypes} or sample;
One of its column names should be "id" whose values correspond to
the name of each \code{Phenotypes} object. We also recommend for it to have
a column named "class" where one of its unique values is "control".}

\item{class}{A string corresponding to the column name or index
of \code{meta} whose values represent
the class label of each sample; OR a vector the same length
as the the number of samples in \code{input_} specifiying the class
of each given sample --- this vector will be appended to \code{meta} under
column name \code{class}.}

\item{no_cores}{An integer indicating how many cores to parallelize on.}

\item{markers}{A string vector of marker names used in \code{input_}.}

\item{layout_fun}{A string of a function from the \code{igraph} package that
indicates what layout should be used if a cell hierarchy is to be ploted;
all such functions have prefix \code{layout_}. This is defaulted to
e.g. \code{layout_fun="layout.reingold.tilford"}.}

\item{max_layer}{And integer indicating the maximum layer in the cell
hierarchy to analyze; set to `NULL` to analyze all layers.}

\item{cumsumpos}{A logical variable indicating whether
or not to cumulate cell counts;
this applies only when \code{partitionsPerMarker > 3} and will convert
e.g. the count of A+ or A++ into the sum of the counts of
A+, A++, A+++, ..., or A++, A+++, ... .}

\item{prop}{A logical variable indicating whether or not to
calculate the proportion feature;
this can be done later on with \code{flowGraph_prop}.}

\item{specenr}{logical variable: whether or not to calculate
the SpecEnr feature, Default: T}

\item{path}{A string indicating the folder path to where the flowGraph
object should save its elements, Default = NULL (don't save).}

\item{calculate_summary}{A logical variable indicating whether or not to
calculate the summary statistics for SpecEnr based on default parameters
using the \code{fg_summary} summary function on class
specified in parameter \code{class}.}

\item{node_features}{A string vector indicating which node feature(s)
to perform summary statistics on; set to \code{NULL} or \code{"NONE"}
and the function will perform summary statistics on all or no node features.}

\item{edge_features}{A string vector indicating which edge feature(s)
to perform summary statistics on; set to \code{NULL} or \code{"NONE"}
and the function will perform summary statistics on all or no edge features.}

\item{test_name}{A string with the name of the test you are performing.}

\item{test_custom}{See \code{\link[flowGraph]{fg_summary}}.}

\item{diminish}{A logical variable; applicable if \code{calculate_summary} is
\code{TRUE}; see \code{\link[flowGraph]{fg_summary}}.}

\item{label1}{A string indicating a class label in
\code{fg_get_meta(fg)[,class]}; set to \code{NULL} if you would
like to compare all classes aganst all classes;
applicable if \code{calculate_summary} is \code{TRUE}.}

\item{label2}{A string indicating a class label in
\code{fg_get_meta(fg)[,class]};
applicable if \code{calculate_summary} is \code{TRUE}.}

\item{save_plots}{A logical indicating whether or not to save plots.}
}
\value{
flowGraph object
}
\description{
Initializes a \code{flowGraph} object given the cell counts
 for one or more flow cytometry sample(s).
 The flowGraph object returned holds meta data
 for each sample, each cell population node,
 edges representing how each cell population node relate to one another,
 and features for these nodes and edges.
}
\details{
\code{flowGraph} is the constructor for the \code{flowGraph} object.
 The user can choose to input as \code{input_} a vector, a \code{Phenotypes}
 object (meaning there is only one sample), a matrix, or a \code{Phenotypes}
 object list. If the user is also inputting a sample meta data frame, it
 must contain a \code{id} column corresponding to sample names.
}
\examples{

no_cores <- 1
samplen <- 10
meta_file <- data.frame(
    id=1:samplen,
    class=append(rep("control", samplen/2), rep("exp", samplen/2)),
    stringsAsFactors=FALSE
)


## using the constructor -----------------------

data(fg_data_pos30)

# input: vector of load-able Phenotypes paths
fg <- flowGraph(fg_data_pos30$count[1,], no_cores=no_cores)

# input: matrix + vector of class corresponding to samples
fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                no_cores=no_cores)
# - save to file directly
# fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
#                no_cores=no_cores, path="path_to_folder)

# input: matrix + meta data frame
# fg <- flowGraph(fg_data_pos30$count, meta=fg_data_pos30$meta,
#                 no_cores=no_cores)


}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_get_feature}}
 \code{\link[flowGraph]{fg_get_feature_desc}}
 \code{\link[flowGraph]{fg_get_summary}}
 \code{\link[flowGraph]{fg_get_summary_desc}}
 \code{\link[flowGraph]{fg_add_feature}}
 \code{\link[flowGraph]{fg_rm_feature}}
 \code{\link[flowGraph]{fg_add_summary}}
 \code{\link[flowGraph]{fg_rm_summary}}
 \code{\link[flowGraph]{fg_gsub_markers}}
 \code{\link[flowGraph]{fg_gsub_ids}}
 \code{\link[flowGraph]{fg_merge_samples}}
 \code{\link[flowGraph]{fg_extract_samples}}
 \code{\link[flowGraph]{fg_extract_phenotypes}}
 \code{\link[flowGraph]{fg_merge}}
 \code{\link[doParallel]{registerDoParallel}}
 \code{\link[Matrix]{Matrix}}
}
