% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_flowgraph_plots.R
\name{fg_plot}
\alias{fg_plot}
\title{Creates a cell hierarchy plot.}
\usage{
fg_plot(
  fg,
  type = "node",
  index = 1,
  summary_meta = NULL,
  adjust_custom = "byLayer",
  show_nodes_edges = NULL,
  label_max = 30,
  p_thres = 0.05,
  filter_adjust0 = 1,
  filter_es = 0,
  filter_btwn_tpthres = 1,
  filter_btwn_es = 0,
  node_labels = c("prop", "expect_prop"),
  summary_fun = colMeans,
  layout_fun = NULL,
  show_bgedges = TRUE,
  main = NULL,
  interactive = FALSE,
  visNet_plot = TRUE,
  path = NULL,
  width = 9,
  height = 9
)
}
\arguments{
\item{fg}{flowGraph object.}

\item{type}{A string indicating feature type the summary was created for
'node' or 'edge'.}

\item{index}{The user must provide \code{type} and
 additionally, one of \code{summary_meta} or \code{index}.

 \code{index} is an integer indicating the row in
 \code{fg_get_summary_desc(<flowGraph>)} of the corresponding type and
 summary the user would like to retrieve.}

\item{summary_meta}{The user must provide \code{type} and
 additionally, one of \code{summary_meta} or \code{index}.

 \code{summary_meta} is a list containing
 \code{feature} (feature name), \code{test_name} (summary statistic name),
 \code{class} (class), \code{label1}, and \code{label2} (class labels compared).
 See \code{\link[flowGraph]{fg_get_summary_desc}} for details.}

\item{adjust_custom}{A function or a string indicating the
test adjustment method to use.
 If a string is provided, it should be one of
 \code{c("holm", "hochberg", "hommel",
 "bonferroni", "BH", "BY", "fdr", "none")} (see \code{p.adjust.methods}).
 If a function is provided, it should take as input
 a numeric vector and output the
 same vector adjusted.}

\item{show_nodes_edges}{A logical vector indicating which nodes/edges (type)
to show in the plot; if this is not specified, only nodes/edges with
significant summary statistics will be shown.}

\item{label_max}{An integer specifying the maximum number of nodes to label.}

\item{p_thres}{A double indicating a summary statistic threshold
e.g. if we are plotting a T test summary statistic, we can set the threshold
to .05; nodes with a p-value greater than .05 will not be plotted.}

\item{filter_adjust0}{A numeric variable indicating what percentage of
SpecEnr values compared (minimum) should be not close to 0.
Set to 1 to not conduct filtering.}

\item{filter_es}{A numeric variable between 0 and 1 indicating what the
Cohen's D value of the nodes/edges in question must be greater or
equal to, to be significant.}

\item{filter_btwn_tpthres}{A numeric variable between 0 and 1 indicating the
unadjusted T-test p-value threshold used to test whether the actual
and expected feature values used to calculate the specified SpecEnr
feature are significantly different for each sample class. Note this only
needs to be specified for SpecEnr features. Combined
with \code{filter_btwn_es}, we conduct three tests to understand if
there is an actual large difference between actual and expected features:
(1,2) T-test of significance between the actual and expected raw feature value
(e.g. proportion) for samples in each of the compared classes, (3) and the
T-test of significance between the differences of actual and
expected feature values of the two classes. If any two of the three tests
come out as insignificant, we set the p-value for the associated node/edge
to 1.}

\item{filter_btwn_es}{A numeric variable between 0 and 1 indicating what the
Cohen's D value of the nodes/edges in question must be greater or
equal to, to be significant -- see \code{filter_btwn_tpthres}.}

\item{node_labels}{A string vector indicating which node feature(s)
should be used to label a node.
We recommend keeping the length of this vector to below 2.
Set to "NONE" if no p-value labels are needed.}

\item{summary_fun}{A function that takes in a matrix and outputs a
vector the same length as the number of columns this matrix has;
see \code{\link[flowGraph]{fg_summary}}.}

\item{layout_fun}{A string representing a function from the
\code{igraph} package that
indicates what layout should be used if a cell hierarchy is to be ploted;
all such functions have prefix \code{layout_}. Only specify if different
from the default one already calculated in the \code{fg} flowGraph object
given.}

\item{show_bgedges}{A logical variable indicating whether or not
edges not specified for plotting should be plotted as
light grey in the background.}

\item{main}{A string or the title of the plot; if left as \code{NULL},
a default title will be applied.}

\item{interactive}{A logical variable indicating whether the plot should be
an interactive plot; see package \code{ggiraph}.}

\item{visNet_plot}{A logical variable indicating if an interactive plot is
chosen, if function should output a visNetwork plot; if set to \code{FALSE},
ggplot's girafe will be used instead.}

\item{path}{A string indicating the path to where the function should save
the plot; leave as \code{NULL} to not save the plot. Static plots are saved
as PNG, interactive plots are saved as HTML.}

\item{width}{A numeric variable specifying, in inches,
what the plot width should be.}

\item{height}{A numeric variable specifying, in inches,
what the plot height should be.}
}
\value{
A list of nodes and edges for plotting with the \code{plot_gr}
 function. Other elements in this list include \code{show_bgedges},
 which has the same value as parameter \code{show_bgedges}, and \code{main},
 the title of the plot.
}
\description{
Creates a cell hierarchy plot given a flowGraph object. If a path is not provided for \code{fg_plot} to save the plot, please use \code{plot_gr} to view plot given the output of \code{fg_plot}.
}
\details{
\code{fg_plot} takes a flowGraph object as input and returns the
 \code{graph} slot of the given object with additional columns to serve as
 input into \code{\link[flowGraph]{plot_gr}} for plotting using functions
 in the \code{ggplot2} package. Users can choose to save a PNG version of
 the plot by filling out the \code{path} parameter with a full path to the
 PNG plot. In addition to specifying columns added from
 \code{\link[flowGraph]{ggdf}}, \code{fg_plot} also adds label column(s)
 whose values serve as labels in the interactive version of the plot.
}
\examples{

 no_cores <- 1
 data(fg_data_pos2)
 fg <- flowGraph(fg_data_pos2$count, class=fg_data_pos2$meta$class,
                 no_cores=no_cores)

 gr <- fg_plot(fg, type="node", index=1, label_max=30,
   show_nodes_edges=NULL, p_thres=.01, node_labels=c("prop", "expect_prop"),
   path=NULL) # set path to a full path to save plot as a PNG
 # plot_gr(gr)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{get_phen_meta}}
 \code{\link[flowGraph]{ggdf}}
 \code{\link[flowGraph]{plot_gr}}
 \code{\link[flowGraph]{fg_get_feature}}
 \code{\link[flowGraph]{fg_get_summary}}
}
