% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_flowgraph_modifiers.R
\name{fg_add_feature}
\alias{fg_add_feature}
\title{Adds a feature.}
\usage{
fg_add_feature(
  fg,
  type = "node",
  feature,
  m = NULL,
  feat_fun = NULL,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{fg}{flowGraph object.}

\item{type}{A string specifying the type of the feature being
added i.e. 'node' or 'edge'.}

\item{feature}{A string indicating the unique name of the feature added.}

\item{m}{A numeric matrix with feature values; it should contain the
same sample id's on row names as in \code{fg_get_meta(fg)$id}
and node or edge names
as column names (i.e. if \code{m} is a node feature, it would have the same
column names as those in \code{fg_get_graph(fg)$v$phenotype};
if it is an edge
feature, its column names should be the same as
\code{paste0(fg_get_graph(fg)$e$from, '_', fg_get_graph(fg)$e$to)}).}

\item{feat_fun}{A function that ouputs a feature matrix as in \code{m} given
\code{fg} and other optional parameters.}

\item{overwrite}{A logical variable indicating whether or not the function
should replace the existing feature with the same name if
one is already in \code{fg}.}

\item{...}{Other parameters that would be used as input into \code{feat_fun}.}
}
\value{
flowGraph object.
}
\description{
Adds a feature created using \code{feat_fun} from \code{fg} OR
 \code{m} into a given flowGraph object. Only use this function if
 you cannot generate the desired features using the existing flowGraph
 functions starting with \code{fg_feat_<feature name>}.
}
\details{
\code{fg_add_feature} adds the given new feature matrix to the
 given flowGraph object \code{fg} updating slots
 \code{feat} and \code{feat_desc}.
 See \code{\link[flowGraph]{flowGraph-class}}
 slot \code{feat} and \code{feat_desc} for what should be in these slots.
 We do not recommend users to directly use this method unless there is
 a clear understanding on how the row and column names should be specified.
 Instead, we recommend users to use the functions listed in the "See also"
 sections prefixed with "fg_feat_".
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 prop=FALSE, specenr=FALSE,
                 no_cores=no_cores)
 fg_get_feature_desc(fg)

 fg <- fg_add_feature(fg, type="node", feature="count_copy",
                      m=fg_data_pos30$count)
 fg_get_feature_desc(fg)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_feat_node_prop}}
 \code{\link[flowGraph]{fg_feat_node_specenr}}
 \code{\link[flowGraph]{fg_get_feature}}
 \code{\link[flowGraph]{fg_rm_feature}}
 \code{\link[flowGraph]{fg_get_feature_desc}}
}
