% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_gate-methods.R
\name{scale_gate}
\alias{scale_gate}
\alias{scale_gate.default}
\title{Simplified geometric scaling of gates}
\usage{
\method{scale_gate}{default}(obj, scale = NULL, ...)
}
\arguments{
\item{obj}{A Gate-type \code{\link{filter}} object (\code{\linkS4class{quadGate}},
\code{\linkS4class{rectangleGate}}, \code{\linkS4class{ellipsoidGate}}, or \code{\linkS4class{polygonGate}})}

\item{scale}{Either a numeric scalar (for uniform scaling in all dimensions) or numeric vector specifying the factor by 
which each dimension of the gate should be expanded (absolute value > 1) or contracted (absolute value < 1). Negative values 
will result in a reflection in that dimension.}

\item{\dots}{Additional arguments not used}
}
\value{
A Gate-type \code{filter} object of the same type as \code{gate}, with the scaling applied
}
\description{
Scale a Gate-type filter object in one or more dimensions
}
\details{
This method allows uniform or non-uniform geometric scaling of filter types defined by simple geometric gates 
(\code{\linkS4class{quadGate}}, \code{\linkS4class{rectangleGate}}, \code{\linkS4class{ellipsoidGate}}, and 
\code{\linkS4class{polygonGate}}) Note that these methods are for manually altering
the geometric definition of a gate. To easily transform the definition of a gate with an accompanyging scale 
transformation applied to its underlying data, see \code{\link[ggcyto]{rescale_gate}}.

The \code{scale} argument passed to \code{scale_gate} should be either a scalar or a vector of the same length
as the number of dimensions of the gate. If it is scalar, all dimensions will be multiplicatively scaled uniformly
by the scalar factor provided. If it is a vector, each dimension will be scaled by its corresponding entry in the vector.

The scaling behavior of \code{scale_gate} depends on the type of gate passed to it. For \code{rectangleGate} 
and \code{quadGate} objects, this amounts to simply scaling the values of the 1-dimensional boundaries. 
For \code{polygonGate} objects, the values of \code{scale} will be used to determine scale factors 
in the direction of each of the 2 dimensions of the gate (\code{scale_gate} is not yet defined
for higher-dimensional \code{polytopeGate} objects). \strong{Important: } For \code{ellipsoidGate} objects, \code{scale}
determines scale factors for the major and minor axes of the ellipse, \emph{in that order}. Scaling by a negative factor 
will result in a reflection in the corresponding dimension.
}
\examples{
\dontrun{
# Scales both dimensions by a factor of 5
scaled_gate <- scale_gate(original_gate, 5)

# Shrinks the gate in the first dimension by factor of 1/2
# and expands it in the other dimension by factor of 3
scaled_gate <- scale_gate(original_gate, c(0.5,3))
}

}
