% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{each_col}
\alias{each_col}
\alias{each_row}
\alias{each_row-methods}
\alias{each_row,flowFrame-method}
\alias{each_col-methods}
\alias{each_col,flowFrame-method}
\title{Methods to apply functions over flowFrame margins}
\usage{
each_col(x, FUN, ...)
each_row(x, FUN, ...)
}
\arguments{
\item{x}{Object of class \code{\linkS4class{flowFrame}}.}

\item{FUN}{the function to be applied. In the case of functions like '+',
'\%*\%', etc., the function name must be backquoted or quoted.}

\item{...}{optional arguments to 'FUN'.}
}
\description{
Returns a vector or array of values obtained by applying a function to the
margins of a flowFrame. This is equivalent of running \code{\link{apply}} on
the output of \code{exprs(flowFrame)}.
}
\examples{

samp <- read.FCS(system.file("extdata", "0877408774.B08", package="flowCore"),
transformation="linearize")
each_col(samp, summary)


}
\seealso{
\code{\link{apply}}
}
\author{
B. Ellis, N. LeMeur, F. Hahne
}
\keyword{methods}
