% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\docType{methods}
\name{plot,flowDens-method}
\alias{plot,flowDens-method}
\alias{plot,flowDens,missing-method}
\alias{plot.flowDens}
\title{Contour or Image Plot of Clustering Results}
\usage{
\S4method{plot}{flowDens,missing}(
  x,
  type = c("contour", "image"),
  nlevels = 30,
  scale = c("raw", "log", "sqrt"),
  color = c("rainbow", "heat.colors", "terrain.colors", "topo.colors", "cm.colors",
    "gray"),
  xlab = colnames(x@dx),
  ylab = colnames(x@dy),
  ...
)
}
\arguments{
\item{x}{The \code{flowDens} object returned from
\code{\link[=density.flowClust]{density}}.}

\item{type}{Either \code{"contour"} or \code{"image"} to specify the type of
plot desired.}

\item{nlevels}{An integer to specify the number of contour levels or colors
shown in the plot.}

\item{scale}{If \code{"log"}, the logarithm of the density values will be
used to generate the plot; similar interpretation holds for \code{"sqrt"}.
The use of a \code{log} or \code{sqrt} elicits more information about low
density regions.}

\item{color}{A string containing the name of the function used to generate
the desired list of colors.}

\item{xlab, ylab}{Labels for the \eqn{x}- and \eqn{y}-axes respectively.}

\item{\dots}{Other arguments to be passed to \code{contour} or \code{image},
for example, \code{drawlabels} and \code{add}.  Once an image plot is
generated, users may impose a contour plot on it by calling this function
with an additional argument \code{add=TRUE}.}
}
\description{
This method makes use of the \code{flowDens} object returned by
\code{\link[=density.flowClust]{density}} to generate a contour or image
plot.
}
\references{
Lo, K., Brinkman, R. R. and Gottardo, R. (2008) Automated Gating
of Flow Cytometry Data via Robust Model-based Clustering. \emph{Cytometry A}
\bold{73}, 321-332.
}
\seealso{
\code{\link{flowClust}}, \code{\link[=density.flowClust]{density}}
}
\author{
Raphael Gottardo <\email{raph@stat.ubc.ca}>, Kenneth Lo
<\email{c.lo@stat.ubc.ca}>
}
\keyword{graphs}
