% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{criterion}
\alias{criterion}
\alias{criterion,flowClust-method}
\alias{criterion,flowClustList-method}
\alias{criterion<-}
\alias{criterion<-,flowClustList,character-method}
\alias{posterior}
\alias{importance}
\alias{uncertainty}
\alias{getEstimates}
\title{Various Functions for Retrieving Information from Clustering Results}
\usage{
criterion(object, ...)

\S4method{criterion}{flowClust}(object, type = "BIC")

\S4method{criterion}{flowClustList}(object, type = "BIC", max = FALSE, show.K = FALSE)

criterion(object) <- value

\S4method{criterion}{flowClustList,character}(object) <- value

posterior(object, assign = FALSE)

importance(object, assign = FALSE)

uncertainty(object)

getEstimates(object, data)
}
\arguments{
\item{object}{Object returned from \code{\link{flowClust}} or
\code{\link[=tmixFilter]{filter}}.  For the replacement method of
\code{criterion}, the object must be of class \code{\link[=flowClust-class]{flowClustList}} or
\code{\link[=tmixFilter-class]{tmixFilterResultList}}.}

\item{\dots}{Further arguments. Currently this is \code{type}, a character
string.  May take \code{"BIC"}, \code{"ICL"} or \code{"logLike"}, to specify
the criterion desired.}

\item{type, value}{A character string stating the criterion used to choose the
best model.  May take either \code{"BIC"} or \code{"ICL"}.}

\item{max}{whether \code{criterion} should return the max value}

\item{show.K}{whether \code{criterion} should return K}

\item{assign}{A logical value.  If \code{TRUE}, only the quantity (\code{z}
for \code{posterior} or \code{u} for \code{importance}) associated with the
cluster to which an observation is assigned will be returned.  Default is
\code{FALSE}, meaning that the quantities associated with all the clusters
will be returned.}

\item{data}{A numeric vector, matrix, data frame of observations, or object
of class \code{flowFrame}; an optional argument.  This is the object on
which \code{\link{flowClust}} or \code{\link[=tmixFilter]{filter}} was
performed.}
}
\value{
Denote by \eqn{K} the number of clusters, \eqn{N} the number of
observations, and \eqn{P} the number of variables.  For \code{posterior} and
\code{importance}, a matrix of size \eqn{N \times K}{N x K} is returned if
\code{assign=FALSE} (default).  Otherwise, a vector of size \eqn{N} is
outputted.  \code{uncertainty} always outputs a vector of size \eqn{N}.
\code{getEstimates} returns a list with named elements, \code{proportions},
\code{locations} and, if the data object is provided, \code{dispersion}.
\code{proportions} is a vector of size \eqn{P} and contains the estimates of
the \eqn{K} cluster proportions.  \code{locations} is a matrix of size
\eqn{K \times P}{K x P} and contains the estimates of the \eqn{K} mean
vectors transformed back to the original scale (i.e., \code{rbox(object@mu,
object@lambda)}).  \code{dispersion} is an array of dimensions \eqn{K \times
P \times P}{K x P x P}, containing the approximate estimates of the \eqn{K}
covariance matrices on the original scale.
}
\description{
Various functions are available to retrieve the information criteria
(\code{criterion}), the posterior probabilities of clustering memberships
\eqn{z} (\code{posterior}), the \dQuote{weights} \eqn{u}
(\code{importance}), the uncertainty (\code{uncertainty}), and the estimates
of the cluster proportions, means and variances (\code{getEstimates})
resulted from the clustering (filtering) operation.
}
\details{
These functions are written to retrieve various slots contained in the
object returned from the clustering operation.  \code{criterion} is to
retrieve \code{object@BIC}, \code{object@ICL} or \code{object@logLike}.  It
replacement method modifies \code{object@index} and \code{object@criterion}
to select the best model according to the desired criterion.
\code{posterior} and \code{importance} provide a means to conveniently
retrieve information stored in \code{object@z} and \code{object@u}
respectively.  \code{uncertainty} is to retrieve \code{object@uncertainty}.
\code{getEstimates} is to retrieve information stored in \code{object@mu}
(transformed back to the original scale) and \code{object@w}; when the data
object is provided, an approximate variance estimate (on the original scale,
obtained by performing one M-step of the EM algorithm without taking the
Box-Cox transformation) will also be computed.
}
\note{
When \code{object@nu=Inf}, the Mahalanobis distances instead of the
\dQuote{weights} are stored in \code{object@u}.  Hence, \code{importance}
will retrieve information corresponding to the Mahalanobis distances. % If
the \code{assign} argument is set to \code{TRUE}, only the quantities
corresponding to assigned observations will be returned.  Quantities
corresponding to unassigned observations (outliers and filtered
observations) will be reported as \code{NA}.  Hence, A change in the rule to
call outliers will incur a change in the number of \code{NA} values
returned.
}
\references{
Lo, K., Brinkman, R. R. and Gottardo, R. (2008) Automated Gating
of Flow Cytometry Data via Robust Model-based Clustering. \emph{Cytometry A}
\bold{73}, 321-332.
}
\seealso{
\code{\link{flowClust}}, \code{\link[=tmixFilter]{filter}},
\code{\link{Map}}
}
\author{
Raphael Gottardo <\email{raph@stat.ubc.ca}>, Kenneth Lo
<\email{c.lo@stat.ubc.ca}>
}
\keyword{cluster}
