% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive_example.R
\name{enrichment_interactive}
\alias{enrichment_interactive}
\title{Small Shiny app serving as example for fast enrichment}
\usage{
enrichment_interactive(de, term_data)
}
\arguments{
\item{de}{Differential expression results, \code{yeast_de} attached to this
package can be used.}

\item{term_data}{A list of \code{fenr_terms} objects containing functional
data for various ontologies. \code{fetch_terms_for_example} can be used to
create this object.}
}
\value{
An interactive Shiny app
}
\description{
Small Shiny app serving as example for fast enrichment
}
\examples{
\dontrun{
data(yeast_de)
term_data <- fetch_terms_for_example(yeast_de)
  enrichment_interactive(yeast_de, term_data)
}
}
