% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist2clusters.R
\name{dist2clusters}
\alias{dist2clusters}
\title{Perform Hierarchical Clustering and tree pruning on a distance matrix}
\usage{
dist2clusters(
  inputDist,
  cutHeight = NULL,
  minClusterSize = 1,
  extra = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{inputDist}{Input distances file location
(generated with \code{\link[fastreeR]{vcf2dist}}
or \code{\link[fastreeR]{fasta2dist}}).
File can be gzip compressed.
Or a \code{\link[stats]{dist}} distances object.}

\item{cutHeight}{Define at which height to cut tree.
Default automatically defined.}

\item{minClusterSize}{Minimum size of clusters. Default 1.}

\item{extra}{Boolean whether to use extra parameters
for the \code{\link[dynamicTreeCut]{cutreeDynamic}}.}

\item{verbose}{Logical. If TRUE, enables verbose output from the Java backend.}
}
\value{
A list of :
\itemize{
    \item \code{\link[base]{character} vector} of the generated
    phylogenetic tree in Newick format
    \item \code{\link[base]{character} vector} of the clusters.
    Each row contains data for a cluster, separated by space.
    The id of the cluster,
    the size of the cluster (number of elements)
    and the names of its elements,
    Cluster id 0 contains all the objects not assigned
    to a cluster (singletons).
    Example clusters output :
    \tabular{lllll}{
        0 \tab 3 \tab Sample1 \tab Sample2 \tab Sample3 \cr
        1 \tab 3 \tab Sample4 \tab Sample5 \tab Sample6 \cr
        2 \tab 2 \tab Sample7 \tab Sample8 \tab \cr
        3 \tab 2 \tab Sample9 \tab Sample0\tab \cr
    }
}
}
\description{
Performs Hierarchical Clustering on a distance matrix
(i.e. calculated with \code{\link[fastreeR]{vcf2dist}}
or \code{\link[fastreeR]{fasta2dist}})
and generates a phylogenetic tree with
agglomerative Neighbor Joining method (complete linkage)
(as in \code{\link[fastreeR]{dist2tree}}).
The phylogenetic tree is then pruned with
\code{\link[dynamicTreeCut]{cutreeDynamic}} to get clusters
(as in \code{\link[fastreeR]{tree2clusters}}).
}
\examples{
my.clust <- dist2clusters(
    inputDist =
        system.file("extdata", "samples.vcf.dist.gz", package = "fastreeR"),
    verbose = TRUE
)
}
\references{
Java implementation:
\url{https://github.com/gkanogiannis/BioInfoJava-Utils}
}
\author{
Anestis Gkanogiannis, \email{anestis@gkanogiannis.com}
}
