% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R
\name{faers_standardize}
\alias{faers_standardize}
\alias{faers_standardize,FAERSascii-method}
\title{Standardize FAERS Quarterly Data for Preferred Term and drug names}
\usage{
faers_standardize(object, ...)

\S4method{faers_standardize}{FAERSascii}(object, meddra_path, add_smq = FALSE)
}
\arguments{
\item{object}{A \link{FAERSascii} object.}

\item{...}{Other arguments passed to specific methods.}

\item{meddra_path}{A string, define the path of MedDRA directory.}

\item{add_smq}{A bool, indicates whether Standardised MedDRA Queries (SMQ)
should be added. If \code{TRUE}, "smq_content.asc", and "smq_list.asc" must exist.}
}
\value{
A \link{FAERSascii} object.
}
\description{
Standardize FAERS Quarterly Data for Preferred Term and drug names
}
\examples{
#' # you must change `dir`, as the files included in the package are sampled
data <- faers(c(2004, 2017), c("q1", "q2"),
    dir = system.file("extdata", package = "faers"),
    compress_dir = tempdir()
)
\dontrun{
# you should replace `meddra_path` with yours
data <- faers_standardize(data, meddra_path)
}
}
\seealso{
\link{MedDRA}
}
