% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-FAERS.R
\docType{class}
\name{FAERS-class}
\alias{FAERS-class}
\alias{FAERS}
\alias{FAERSascii-class}
\alias{FAERSascii}
\alias{FAERSxml-class}
\alias{FAERSxml}
\alias{show,FAERS-method}
\alias{show,FAERSascii-method}
\alias{faers_data}
\alias{faers_data,FAERS-method}
\alias{faers_year}
\alias{faers_year,FAERS-method}
\alias{faers_quarter}
\alias{faers_quarter,FAERS-method}
\alias{faers_period}
\alias{faers_period,FAERS-method}
\alias{faers_meddra}
\alias{faers_meddra,FAERS-method}
\alias{faers_deleted_cases}
\alias{faers_deleted_cases,FAERSascii-method}
\alias{faers_field}
\alias{faers_header}
\alias{faers_header,FAERSxml-method}
\title{FAERS class}
\usage{
\S4method{show}{FAERS}(object)

\S4method{show}{FAERSascii}(object)

faers_data(object, ...)

\S4method{faers_data}{FAERS}(object)

faers_year(object)

\S4method{faers_year}{FAERS}(object)

faers_quarter(object)

\S4method{faers_quarter}{FAERS}(object)

faers_period(object)

\S4method{faers_period}{FAERS}(object)

faers_meddra(object, ...)

\S4method{faers_meddra}{FAERS}(object, use = NULL)

faers_deleted_cases(object, ...)

\S4method{faers_deleted_cases}{FAERSascii}(object)

faers_header(object)

\S4method{faers_header}{FAERSxml}(object)
}
\arguments{
\item{object}{A \code{FAERS} object.}

\item{...}{Other arguments passed to specific methods.}

\item{use}{A string, what meddra data to use, "hierarchy" or "smq". If
\code{NULL}, a \link{MedDRA} will be returned. Only used when \code{object} has been
standardized}
}
\value{
See details.
}
\description{
Provide a container for FAERS Quarterly Data file
}
\details{
\itemize{
\item \code{faers_data}: Extract the \code{data} slot.
\item \code{faers_year}: Extract the \code{year} slot.
\item \code{faers_quarter}: Extract the \code{quarter} slot.
\item \code{faers_period}: A \link[data.table:data.table]{data.table} combine the \code{year}
and \code{quarter} slot.
\item \code{faers_meddra}: Extract the \code{meddra} slot. If \code{object} have never been
standardized, always return \code{NULL}.
\item \code{faers_deleted_cases}: Extract the \code{deletedCases} slot.
}
}
\section{Slots}{

\describe{
\item{\code{year}}{An integer specifies the year information.}

\item{\code{quarter}}{A string specifies the quarter information.}

\item{\code{data}}{For \code{FAERSxml}, a \link[data.table:data.table]{data.table}. For
\code{FAERSascii}, a list of \link[data.table:data.table]{data.table}.}

\item{\code{meddra}}{A \link{MedDRA} or \code{NULL} representing the meddra data used for
standardization.}

\item{\code{format}}{A string of "ascii" or "xml" indicates the file format used.}

\item{\code{deletedCases}}{An atomic character, as of 2019 Quarter one there are new
files that lists deleted cases. \link{faers_dedup} will remove cases in this slot.}

\item{\code{standardization}}{A bool, indicates whether standardization has been
performed.}

\item{\code{deduplication}}{A bool, indicates whether deduplication has been
performed.}
}}

\examples{
# ususaly we use faers() function to create a `FAERS` object
# you must change `dir`, as the file included in the package is sampled
data <- faers(2004, "q1",
    dir = system.file("extdata", package = "faers"),
    compress_dir = tempdir()
)
faers_data(data)
faers_year(data)
faers_quarter(data)
faers_period(data)
faers_meddra(data)
faers_deleted_cases(data)
}
