% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/partitionRanges.R
\name{partitionRanges}
\alias{partitionRanges}
\alias{partitionRanges,GRanges,GRanges-method}
\title{Partition a set of Genomic Ranges}
\usage{
partitionRanges(x, y, ...)

\S4method{partitionRanges}{GRanges,GRanges}(
  x,
  y,
  y_as_both = TRUE,
  ignore.strand = FALSE,
  simplify = TRUE,
  suffix = c(".x", ".y"),
  ...
)
}
\arguments{
\item{x, y}{GenomicRanges objects}

\item{...}{Not used}

\item{y_as_both}{logical(1) If there are any unstranded regions in y, should
these be assigned to both strands. If TRUE unstranded regions can be used
to partition stranded regions}

\item{ignore.strand}{If set to TRUE, then the strand of x and y is set to
"*" prior to any computation.}

\item{simplify}{Pass to chopMC and simplify mcols in the output}

\item{suffix}{Added to any shared column names in the provided objects}
}
\value{
A GRanges object
}
\description{
Partition a set of Genomic Ranges by another
}
\details{
The query set of ranges can be broken in regions which strictly overlap
a second set of ranges.
The complete set of mcols from both initial objects will included in the
set of partitioned ranges
}
\examples{
x <- GRanges(c("chr1:1-10", "chr1:6-15"))
x$id <- paste0("range", seq_along(x))
x
y <- GRanges(c("chr1:2-5", "chr1:6-12"))
y$id <- paste0("range", seq_along(y))
y
partitionRanges(x, y)

}
