% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metricsAnalysis.R
\name{plotMetricsViolin}
\alias{plotMetricsViolin}
\title{Metric values as violin plot.}
\usage{
plotMetricsViolin(data, nplots = 20)
}
\arguments{
\item{data}{A \code{\link{SummarizedExperiment}}.
The SummarizedExperiment must contain an assay with the following structure:
A valid header with names. The first  column of the header is the ID or name
of the instance of the dataset (e.g., ontology, pathway, etc.) on which the
metrics are measured.
The other columns of the header contains the names of the metrics.
The rows contains the measurements of the metrics for each instance in the dataset.}

\item{nplots}{Positive integer. Number of metrics per violin plot. Default: 20.}
}
\value{
Nothing.
}
\description{
It plots the value of the metrics in a \code{\link{SummarizedExperiment}}
object as a violin plot.
}
\examples{
# Using example data from our package
data("ontMetrics")
plotMetricsViolin(ontMetrics)

}
