% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictions.R
\name{globalMetric}
\alias{globalMetric}
\title{Global metric score defined by a prediction.}
\usage{
globalMetric(data, k.range = c(2, 15), nrep = 10,
  criterion = c("BIC", "AIC"), PCA = FALSE, seed = NULL)
}
\arguments{
\item{data}{A \code{\link{SummarizedExperiment}}.
The SummarizedExperiment must contain an assay with the following structure:
A valid header with names. The first  column of the header is the ID or name
of the instance of the dataset (e.g., ontology, pathway, etc.) on which the
metrics are measured.
The other columns of the header contains the names of the metrics.
The rows contains the measurements of the metrics for each instance in the dataset.}

\item{k.range}{Concatenation of two positive integers.
The first value \code{k.range[1]} is considered as the lower bound of the range,
whilst the second one, \code{k.range[2]}, as the higher. Both values must be
contained in [2,15] range.}

\item{nrep}{Positive integer. Number of random initializations used in adjusting the model.}

\item{criterion}{String. Critirion applied in order to select the best model. Possible values:
"BIC" or "AIC".}

\item{PCA}{Boolean. If true, a PCA is performed on the input dataframe before computing
the predictions.}

\item{seed}{Positive integer. A seed for internal bootstrap.}
}
\value{
A dataframe containing the global metric score for each metric.
}
\description{
This analysis calculates a global metric score based upon a prediction model
computed with \code{\link{flexmix}} package.
}
\examples{
# Using example data from our package
data("rnaMetrics")
globalMetric(rnaMetrics, k.range = c(2,3), nrep=10, criterion="AIC", PCA=TRUE)



}
