% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metricsAnalysis.R
\name{getMetricsRelevancy}
\alias{getMetricsRelevancy}
\alias{getMetricRangeByCluster}
\title{Get the range of each metric per cluster from the optimal cluster.
getMetricRangeByCluster}
\usage{
getMetricsRelevancy(df, k, alpha = NULL, L1 = NULL, seed = NULL)
}
\arguments{
\item{df}{Input data frame. The first column denotes the identifier of the
evaluated individuals. The remaining columns contain the metrics used to
evaluate the individuals. Rows with NA values will be ignored.}

\item{k}{K value (number of clusters)}

\item{alpha}{0 <= alpha <= 1, the proportion of the cases to be trimmed in robust sparse K-means, see \code{\link{RSKC}}.}

\item{L1}{A single L1 bound on weights (the feature weights), see \code{\link{RSKC}}.}

\item{seed}{Random seed to be used.}
}
\value{
A dataframe including the min and the max value for each
pair (metric, cluster).
}
\description{
Obtains the ranges of the metrics obtained by each optimal cluster.
}
\examples{
data("ontMetrics")
metricsRelevancy = getMetricsRelevancy(ontMetrics, k=3, alpha=0.1, seed=100)
metricsRelevancy$rskc # RSKC output object
metricsRelevancy$trimmed_cases # Trimmed cases from input (row indexes)
metricsRelevancy$relevancy # Metrics relevancy table

}
