% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{getDataQualityRange}
\alias{getDataQualityRange}
\title{Dataframe getter for \code{qualityRange} function.}
\usage{
getDataQualityRange(data, k)
}
\arguments{
\item{data}{The object returned by \code{\link{qualityRange}} function.}

\item{k}{The desired \code{k} cluster.}
}
\value{
The \code{\link{SummarizedExperiment}} that contains information about the selected \code{k} cluster.
}
\description{
This method is a wrapper to retrieve a specific \code{\link{SummarizedExperiment}} given a \code{k} value from
the object returned by \code{\link{qualityRange}} function.
}
\examples{
# Using example data from our package
data("ontMetrics")
qualityRangeData <- qualityRange(ontMetrics, k.range=c(3,5), getImages = FALSE)
# Getting dataframe that contains information about k=5
k5Data = getDataQualityRange(qualityRangeData, 5)

}
