% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contingencyCount.R
\name{contingencyCount}
\alias{contingencyCount}
\title{Contingency Table Construction}
\usage{
contingencyCount(x, micro.anno=NULL, comp.anno=NULL)
}
\arguments{
\item{x}{See \code{x} in \code{\link{Cartesian}}, the x values should be difference values without log converted.}

\item{micro.anno}{See \code{micro.anno} in \code{\link{Cartesian}}.}

\item{comp.anno}{See \code{comp.anno} in \code{\link{Cartesian}}.}
}
\value{
The frequencies of condition-impact terms in contingency table
}
\description{
Computes the frequencies of the contingency table as the cumulated microbial abundance difference classified into each condition and eubiotic/dysbiotic impact term for examining the significance of the association (contingency) between conditions and impacts by  \code{\link{contingencyTest}}.
}
\details{
Eubiotic impact is measured by variations of increased harmless and decreased harmful microbes, while the dysbiotic impact is measured by the decreased harmless and increased harmful microbes.
}
\examples{
data(microDiff)
attach(microDiff)

microCount = contingencyCount(x = data, micro.anno = micro.anno,
                      comp.anno = comp.anno)

detach(microDiff)
}

