% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cartesian.R
\name{Cartesian}
\alias{Cartesian}
\title{2-D Cartesian plane Plots}
\usage{
Cartesian(x,log2 = TRUE,micro.anno = NULL, comp.anno = NULL,
             pch = 16, point.col = NULL,point.alpha = 0.6,ylim = NULL, 
             xlab = NULL,ylab = NULL,vlty = 2, hlty = 1, srt = 60,
             font = 3, adj = c(1,1), xaxis = NULL, yaxis = NULL, legend = TRUE,
             box = TRUE,box.col = c("darkblue","yellow"),
             ...)
}
\arguments{
\item{x}{a data frame or numeric matrix of microbial abundance variations from which the plot is produced. Rows indicate the differential microbes, columns indicate the pair-wise conditions. \code{x} values can either be difference values or be \emph{log2} converted, specified with \code{log2} parameter.}

\item{log2}{logical, specifying if x values should be \emph{log2} converted; default to \code{TRUE}.}

\item{micro.anno}{a character vector to annotate all row microbes in \code{x}; e.g. \code{"harmless"},\code{"harmful"}, should be in same length with the microbes. It can be given by the output of \code{\link{microAnnotate}}}

\item{comp.anno}{a character vector of conditions pre-defined from the column pair-wise comparisons, should be in same length with the comparisons; default to the pair-wise comparisons.}

\item{pch}{a vector of point types. Graphical parameters:see \code{\link[graphics]{par}}.}

\item{point.col}{a vector of colors for the points.}

\item{point.alpha}{alpha value for points; see \code{\link[grDevices]{adjustcolor}}.}

\item{ylim}{limits for the y axis.}

\item{xlab}{a title for the x axis.}

\item{ylab}{a title for the y axis.}

\item{vlty, hlty}{types of vertical and horizontal lines to divide the plane with x-axis and y-axis, respectively.}

\item{srt, font, adj}{graphical parameters for the text on x-axis, see \code{\link[graphics]{par}}.}

\item{xaxis}{a character or expression vector specifying the labels of x axis by \emph{text}; default to row names of \code{x}.}

\item{yaxis}{a character or expression vector specifying the labels of y axis by \emph{axis}; default to \code{at} values in \code{\link[graphics]{axis}}.}

\item{legend}{logical, specifying if the legend should be added to the plot; default to \code{TRUE}.}

\item{box}{logical, specifying if the quadrants should be highlighted by boxes; default to \code{TRUE}.}

\item{box.col}{a vector of colors for the  up-utmost right, bottom-utmost left quadrants and bottom-utmost right, up-utmost left quadrants, respectively; default to "darkblue" and "yellow". If only one color is specified, the other one can be \code{NA}.}

\item{...}{additional parameters passed to the default method, or by it to \code{\link[graphics]{plot.window}}, \code{\link[graphics]{text}},\code{\link[graphics]{mtext}},\code{\link[graphics]{axis}}, and \code{\link[graphics]{title}} to control the appearance of the plot.}
}
\value{
The Cartesian plane plot
}
\description{
This function plots a Cartesian plane of genus abundance difference across the tested conditions (y-axis) and their harmful/harmless nature (negative/positive x-axis), giving rise to up-utmost right and bottom-utmost left quadrants of microbial eubiotic impact and bottom-utmost right and up-utmost left quadrants of dysbiotic impact.
}
\examples{
data(microDiff)
attach(microDiff)

newpar = par()
par(mar = c(6,5.1,4.1,6))
Cartesian(x = data,log2 = TRUE,micro.anno = micro.anno,pch = 16,
         comp.anno = comp.anno,point.col = c("blue","purple","orange"))

par(newpar)
detach(microDiff)
}

