% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitEnrichment.R
\name{splitEnrichment}
\alias{splitEnrichment}
\title{Plot Enrichment Distributions Using Split or Dodged Violin Plots}
\usage{
splitEnrichment(
  input.data,
  assay = NULL,
  split.by = NULL,
  group.by = NULL,
  gene.set.use = NULL,
  order.by = NULL,
  facet.by = NULL,
  scale = TRUE,
  palette = "inferno"
)
}
\arguments{
\item{input.data}{Output of \code{\link{escape.matrix}} or a single-cell
object previously processed by \code{\link{runEscape}}.}

\item{assay}{Character. Name of the assay holding enrichment scores when
\code{input.data} is a single-cell object. Ignored otherwise.}

\item{split.by}{Character. Metadata column used to split or color violins.
Must contain at least two levels. If more than two levels are present,
dodged violins are used instead of split violins.}

\item{group.by}{Character. Metadata column plotted on the x-axis. Defaults
to the Seurat/SCE \code{ident} slot when \code{NULL}.}

\item{gene.set.use}{Character. Name of the gene set to display.}

\item{order.by}{Character or \code{NULL}. How to arrange the x-axis:
\itemize{
  \item \code{"mean"}: Groups ordered by decreasing group mean.
  \item \code{"group"}: Natural (alphanumeric) sort of group labels.
  \item \code{NULL} (default): Keep original ordering.
}}

\item{facet.by}{Character or \code{NULL}. Metadata column used to facet
the plot.}

\item{scale}{Logical. If \code{TRUE}, scores are centered and scaled
(Z-score) prior to plotting. Default is \code{TRUE}.}

\item{palette}{Character. Color palette name from
\code{\link[grDevices]{hcl.pals}}. Default is \code{"inferno"}.}
}
\value{
A [ggplot2] object.
}
\description{
Visualize the distribution of gene set enrichment scores across groups using
violin plots. When \code{split.by} contains exactly two levels, the function
draws split violins for easy group comparison within each \code{group.by}
category. If \code{split.by} has more than two levels, standard dodged
violins are drawn instead.
}
\examples{
gs <- list(Bcells = c("MS4A1", "CD79B", "CD79A", "IGH1", "IGH2"),
           Tcells = c("CD3E", "CD3D", "CD3G", "CD7","CD8A"))
           
pbmc <- SeuratObject::pbmc_small |>
  runEscape(gene.sets = gs, min.size = NULL)

splitEnrichment(input.data = pbmc,
                assay = "escape",
                split.by = "groups",
                gene.set.use = "Tcells")

}
