% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitEnrichment.R
\name{splitEnrichment}
\alias{splitEnrichment}
\title{Plot Enrichment Distributions Using Split or Dodged Violin Plots}
\usage{
splitEnrichment(
  input.data,
  assay = NULL,
  split.by = NULL,
  group.by = NULL,
  gene.set.use = NULL,
  order.by = NULL,
  facet.by = NULL,
  scale = TRUE,
  palette = "inferno"
)
}
\arguments{
\item{input.data}{Output of \code{\link{escape.matrix}} or a single‑cell
object previously processed by \code{\link{runEscape}}.}

\item{assay}{Name of the assay holding enrichment scores when
`input.data` is a single‑cell object. Ignored otherwise.}

\item{split.by}{A metadata column used to split or color violins. Must contain 
at least two levels. If it contains more than two, dodged violins are used.}

\item{group.by}{Metadata column plotted on the *x*‑axis.  Defaults to the
Seurat/SCE `ident` slot when `NULL`.}

\item{gene.set.use}{Character(1).  Name of the gene set to display.}

\item{order.by}{How to arrange the x‑axis:
*`"mean"`* – groups ordered by decreasing group mean;
*`"group"`* – natural sort of group labels;
*`NULL`* – keep original ordering.}

\item{facet.by}{Optional metadata column used to facet the plot.}

\item{scale}{Logical; if `TRUE` scores are centred/scaled (Z‑score) prior
to plotting.}

\item{palette}{Character. Any palette from \code{\link[grDevices]{hcl.pals}}.}
}
\value{
A [ggplot2] object.
}
\description{
Visualize the distribution of gene set enrichment scores across groups using
violin plots. When `split.by` contains exactly two levels, the function draws
split violins for easy group comparison within each `group.by` category. If
`split.by` has more than two levels, standard dodged violins are drawn instead.
}
\examples{
gs <- list(Bcells = c("MS4A1", "CD79B", "CD79A", "IGH1", "IGH2"),
           Tcells = c("CD3E", "CD3D", "CD3G", "CD7","CD8A"))
           
pbmc <- SeuratObject::pbmc_small |>
  runEscape(gene.sets = gs, min.size = NULL)

splitEnrichment(input.data = pbmc,
                assay = "escape",
                split.by = "groups",
                gene.set.use = "Tcells")

}
