% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterEnrichment.R
\name{scatterEnrichment}
\alias{scatterEnrichment}
\title{Plot 2D Enrichment Distributions With Density or Hexplots}
\usage{
scatterEnrichment(
  input.data,
  assay = NULL,
  x.axis,
  y.axis,
  facet.by = NULL,
  group.by = NULL,
  color.by = c("density", "group", "x", "y"),
  style = c("point", "hex"),
  scale = FALSE,
  bins = 40,
  point.size = 1.2,
  alpha = 0.8,
  palette = "inferno",
  add.corr = FALSE
)
}
\arguments{
\item{input.data}{Output of \code{\link{escape.matrix}} or a single‑cell
object previously processed by \code{\link{runEscape}}.}

\item{assay}{Name of the assay holding enrichment scores when
`input.data` is a single‑cell object. Ignored otherwise.}

\item{x.axis, y.axis}{Gene-set names to plot on the *x* and *y* axes.}

\item{facet.by}{Optional metadata column used to facet the plot.}

\item{group.by}{Metadata column plotted.  Defaults to the
Seurat/SCE `ident` slot when `NULL`.}

\item{color.by}{Aesthetic mapped to point color. Use 
`"density"` (default), `"group"`, `"x"`, or `"y"`.  The latter two apply a 
continuous gradient to the corresponding axis.}

\item{style}{`"point"` (density-aware points) or `"hex"` (hex-bin).}

\item{scale}{Logical; if `TRUE` scores are centered/scaled (Z‑score) prior
to plotting.}

\item{bins}{Number of hex bins along each axis when `style = "hex"`.}

\item{point.size, alpha}{Aesthetic tweaks for `style = "point"`.}

\item{palette}{Character. Any palette from \code{\link[grDevices]{hcl.pals}}.}

\item{add.corr}{Logical. Add Pearson and Spearman correlation
coefficients (top-left corner of the first facet).}
}
\value{
A \pkg{ggplot2} object.
}
\description{
Visualize the relationship between *two* enrichment scores at single-cell
resolution. By default points are shaded by local 2-D density
(`color.by = "density"`), but users can instead color by a metadata column
(discrete) or by the raw gene-set scores themselves (continuous).
}
\examples{
gs <- list(
  Bcells = c("MS4A1","CD79B","CD79A","IGH1","IGH2"),
  Tcells = c("CD3E","CD3D","CD3G","CD7","CD8A")
)
pbmc <- SeuratObject::pbmc_small |>
  runEscape(gene.sets = gs, min.size = NULL)

scatterEnrichment(
  pbmc,
  assay     = "escape",
  x.axis    = "Tcells",
  y.axis    = "Bcells",
  color.by  = "group",        
  group.by  = "groups",
  add.corr  = TRUE,
  point.size = 1
)

}
