% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gseaEnrichment.R
\name{gseaEnrichment}
\alias{gseaEnrichment}
\title{Classical GSEA-style Running-Enrichment Plot}
\usage{
gseaEnrichment(
  input.data,
  gene.set.use,
  gene.sets,
  group.by = NULL,
  summary.fun = "mean",
  p = 1,
  nperm = 1000,
  rug.height = 0.02,
  digits = 2,
  BPPARAM = NULL,
  palette = "inferno"
)
}
\arguments{
\item{input.data}{A \link[SeuratObject]{Seurat} object or a
\link[SingleCellExperiment]{SingleCellExperiment}.}

\item{gene.set.use}{Character(1). Name of the gene set to display.}

\item{gene.sets}{A named list of character vectors, the result of
[getGeneSets()], or the built-in data object [escape.gene.sets].}

\item{group.by}{Metadata column. Defaults to the Seurat/SCE `ident` 
slot when `NULL`.}

\item{summary.fun}{Method used to collapse expression within each
group **before** ranking: one of `"mean"` (default), `"median"`, `"max"`,
`"sum"`, or `"geometric"`.}

\item{p}{Weighting exponent in the KS statistic (classical GSEA uses `p = 1`).}

\item{nperm}{Integer >= 0. Gene-label permutations per group (default 1000). 
`0` value will skip NES/*p* calculation.}

\item{rug.height}{Vertical spacing of the hit rug as a fraction of the
y-axis (default `0.02`).}

\item{digits}{Number of decimal places displayed for ES in the
legend (default `2`).}

\item{BPPARAM}{A \pkg{BiocParallel} parameter object describing the
parallel backend.}

\item{palette}{Character. Any palette from \code{\link[grDevices]{hcl.pals}}.}
}
\value{
A single `patchwork`/`ggplot2` object
}
\description{
Produces the familiar two-panel GSEA graphic—running enrichment score
(RES) plus a “hit” rug—for a **single gene-set** evaluated across
multiple biological groups (clusters, conditions, samples, ...).
}
\details{
**Algorithm (Subramanian _et al._, PNAS 2005)**  
1. Within every group, library-size-normalise counts to CPM.  
2. Collapse gene expression with `summary.fun` (mean/median/…).  
3. Rank genes (descending) to obtain one ordered list per group.  
4. Compute the weighted Kolmogorov–Smirnov running score  
   (weight = \|stat\|^*p*).  
5. ES = maximum signed deviation of the curve.
}
\examples{
pbmc_small <- SeuratObject::pbmc_small

gs <- list(Bcells = c("MS4A1", "CD79B", "CD79A", "IGH1", "IGH2"),
           Tcells = c("CD3E", "CD3D", "CD3G", "CD7","CD8A"))

gseaEnrichment(pbmc_small,
               gene.set.use = "Bcells",
               gene.sets    = gs,
               group.by     = "groups",
               summary.fun  = "mean",
               digits       = 3)

}
\seealso{
\code{\link{escape.matrix}}, \code{\link{densityEnrichment}}
}
