% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{getMotifInfo}
\alias{getMotifInfo}
\title{Generate PFMatrix or PFMatrixList from file.}
\usage{
getMotifInfo(motif.file = NULL)
}
\arguments{
\item{motif.file}{Motif PFM file downloaded from JASPAR.}
}
\value{
\code{\link{PFMatrix}} or \code{\link{PFMatrixList}}.
}
\description{
atacMotifScan and atacMotifScanPair accept PFM in a \code{list}, this
function convert JASPAR PFM file to \code{\link{PFMatrix}} or \code{\link{PFMatrixList}}.
}
\details{
Generate \code{\link{PFMatrix}} or \code{\link{PFMatrixList}}.
}
\examples{

motif_file <- system.file("extdata", "CustomizedMotif.txt", package="esATAC")
pfm <- getMotifInfo(motif.file = motif_file)

}
\author{
Wei Zhang
}
