% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initDat.R
\name{initDat}
\alias{initDat}
\title{Initialize the exDat list}
\usage{
initDat(
  datType = NULL,
  isNorm = FALSE,
  exTable = NULL,
  repNormFactor = NULL,
  filenameRoot = NULL,
  sample1Name = NULL,
  sample2Name = NULL,
  erccmix = "RatioPair",
  erccdilution = 1,
  spikeVol = 1,
  totalRNAmass = 1,
  choseFDR = 0.05,
  ratioLim = c(-4, 4),
  signalLim = c(-14, 14),
  userMixFile = NULL
)
}
\arguments{
\item{datType}{type is "count" or "array", unnormalized data is
expected (normalized data may be accepted in future
version of the package). Default is "count" (integer 
count data),"array" is unnormalized fluorescent 
intensities from microarray
fluorescent intensities (not log transformed or 
normalized)}

\item{isNorm}{default is FALSE, if FALSE then the unnormalized
input data will be
normalized in erccdashboard analysis. If TRUE then
it is expected that the data is already normalized}

\item{exTable}{data frame, the first column contains names of 
genes or transcripts (Feature) and the remaining columns
are counts for sample replicates spiked with ERCC 
controls}

\item{repNormFactor}{optional vector of normalization factors for each 
replicate, default value is NULL and 75th percentile
normalization will be applied to replicates}

\item{filenameRoot}{string root name for output files}

\item{sample1Name}{string name for sample 1 in the gene expression 
experiment}

\item{sample2Name}{string name for sample 2 in the gene expression
experiment}

\item{erccmix}{Name of ERCC mixture design, "RatioPair" is 
default, the other option is "Single"}

\item{erccdilution}{unitless dilution factor used in dilution of the Ambion 
ERCC spike-in mixture solutions}

\item{spikeVol}{volume in microliters of diluted ERCC mix spiked into
the total RNA samples}

\item{totalRNAmass}{mass in micrograms of total RNA spiked with diluted ERCC
mixtures}

\item{choseFDR}{False Discovery Rate for differential expression testing
, default is 0.05}

\item{ratioLim}{Limits for ratio axis on MA plot, default is c(-4,4)}

\item{signalLim}{Limits for signal axis on dynamic range plot, default 
is c(-14,14)}

\item{userMixFile}{optional filename input, default is NULL, if ERCC 
control ratio mixtures other than the Ambion product
were used then a userMixFile can be used for the 
analysis}
}
\description{
Initialize the exDat list
}
\examples{

data(SEQC.Example)

exDat <- initDat(datType="count", isNorm = FALSE, exTable=MET.CTL.countDat, 
                 filenameRoot = "testRun",sample1Name = "MET",
                 sample2Name = "CTL", erccmix = "RatioPair", 
                 erccdilution = 1/100, spikeVol = 1, totalRNAmass = 0.500,
                 choseFDR = 0.1)
summary(exDat)                      
                                        

}
