% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EpivizNavigation-class.R
\docType{class}
\name{EpivizNavigation-class}
\alias{EpivizNavigation-class}
\alias{EpivizNavigation}
\title{Data container for an Epiviz navigation component.}
\description{
Data container for an Epiviz navigation component.
}
\section{Fields}{

\describe{
\item{\code{gene}}{(character) Gene}

\item{\code{geneInRange}}{(character) Nearest Gene in range.}

\item{\code{parent}}{An object of class \code{\link{EpivizEnvironment}} where navigation is appended.}
}}

\section{Methods}{

\describe{
\item{\code{add_genome(genome, type = "gene_info", datasource_name = NULL)}}{Add a genome to the view, and a genes-track.
\describe{
  \item{genome}{annotation object. eg. Homo.sapiens}
}}

\item{\code{clone_charts(charts)}}{Clone EpivizCharts and append to navigation. Each chart must already
exist in the navigation's data manager, otherwise an error will occur
when attempting to intialize using their measurements
\describe{
\item{charts}{list of EpivizCharts whose data exists in the
navigation's data manager }}}

\item{\code{get_attributes()}}{Get attributes for rendering chart}

\item{\code{get_component_type()}}{Get component type for prefix of random id generator}

\item{\code{get_gene()}}{Get gene}

\item{\code{get_geneInRange()}}{Get gene in range}

\item{\code{get_name()}}{Get name of Epiviz Web Component}

\item{\code{render_component(shiny = FALSE)}}{Render to html
\describe{
  \item{shiny}{ if rendering component in a shiny environment}
}}

\item{\code{set_gene(gene)}}{Set gene}

\item{\code{set_geneInRange(gene)}}{Set step ratio}
}}

