% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRanges2RSE.R
\name{GRanges2RSE}
\alias{GRanges2RSE}
\title{GRanges2RSE()}
\usage{
GRanges2RSE(gr, patterns, names = patterns)
}
\arguments{
\item{gr}{a \code{GRanges} object with matrix embeded as metadata columns.}

\item{patterns}{A character vector of column prefixes
(can be regular expressions) that should match columns of \code{gr}.}

\item{names}{specify the desired names
of the assays (if different from patterns).}
}
\value{
a \code{RangedSummarizedExperiment}.
}
\description{
Convert objects from the old input format
(\code{GRanges} object) to the new recommanded input format
\code{RangedSummarizedExperiment}.
}
\details{
Mostly used for backward compatibilities and unit testing.
}
\examples{
data("stackepi_gr")
GRanges2RSE(stackepi_gr, patterns = c("window"))
GRanges2RSE(stackepi_gr, patterns = c("^window_"), names = c("DNAme"))
}
