% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotActivityDim}
\alias{plotActivityDim}
\title{Plot cell-level reduced dimension results stored in a SingleCellExperiment object, colored by activities for a list of TFs}
\usage{
plotActivityDim(
  sce = NULL,
  activity_matrix,
  tf,
  dimtype = "UMAP",
  label = NULL,
  ncol = NULL,
  nrow = NULL,
  title = NULL,
  combine = TRUE,
  legend.label = "activity",
  colors = c("blue", "yellow"),
  limit = NULL,
  ...
)
}
\arguments{
\item{sce}{A SingleCellExperiment object containing dimensionality reduction coordinates}

\item{activity_matrix}{A matrix of TF activities inferred from calculateActivity}

\item{tf}{A character vector indicating the names of the transcription factors to be plotted}

\item{dimtype}{String indicating the name of dimensionality reduction matrix to be extracted from the SingleCellExperiment}

\item{label}{String corresponding to the field in the colData of sce for annotation on plot}

\item{ncol}{A integer to specify the number of columns in the combined plot, if combine == TRUE}

\item{nrow}{A integer to specify the number of rows in the combined plot, if combine == TRUE}

\item{title}{A string to specify the name of the combined plot}

\item{combine}{logical to indicate whether to combine and visualize the plots in one panel}

\item{legend.label}{String indicating the name of variable to be plotted on the legend}

\item{colors}{A vector of 2 colors for the intensity, with the first element referring to the lower value and
the second element referring to the higher value. Default is c('blue','yellow').}

\item{limit}{A vector of lower and upper bounds for the color scale. The default option is NULL and will adjust
to minimal and maximal values}

\item{...}{Additional arguments from scater::plotReducedDim}
}
\value{
A combined ggplot object or a list of ggplots if combine == FALSE
}
\description{
Plot cell-level reduced dimension results stored in a SingleCellExperiment object, colored by activities for a list of TFs
}
\examples{
# create a mock singleCellExperiment object for gene expression matrix
example_sce <- scuttle::mockSCE()
example_sce <- scuttle::logNormCounts(example_sce)
example_sce <- scater::runPCA(example_sce)
example_sce <- scater::runUMAP(example_sce)
example_sce$cluster <- sample(LETTERS[1:5], ncol(example_sce), replace = TRUE)
plotActivityDim(sce = example_sce, activity = logcounts(example_sce),
tf = c('Gene_0001','Gene_0002'),  label = 'cluster')
}
\author{
Xiaosai Yao, Shang-yang Chen
}
